package gov.va.med.mhv.phr.allergy.backing;

import gov.va.med.mhv.phr.allergy.portlet.AllergyPageFlowController;
import gov.va.med.mhv.phr.backing.ExtractBaseBacking;
import gov.va.med.mhv.phr.util.SessionManagement;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.service.delegate.InPersonAuthenticationServiceDelegate;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;

import javax.servlet.http.HttpServletRequest;


public class AllergyExtractBacking extends ExtractBaseBacking {

	private static final long serialVersionUID = 1L;
	private static final ExtractType EXTRACT_TYPE = ExtractType.getEnum(
        ExtractType.ALLERGY);
    
    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.backing.ExtractBaseBacking#getExtractType()
     */
    @Override
    protected ExtractType getExtractType() {
        return EXTRACT_TYPE;
    }

    /*
     * (non-Javadoc)
     * @see gov.va.med.mhv.phr.backing.ExtractBaseBacking#getControllerClass()
     */
    @Override
    protected Class getControllerClass() {
        return AllergyPageFlowController.class;
    }

    protected boolean allowAdvancedPatient(Patient patient, HttpServletRequest request) {
		// Adding for MVI Account Status Check
		Boolean isPatientAuthenticated = null;
    	InPersonAuthenticationServiceDelegate delegate = 
    		gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createInPersonAuthenticationServiceDelegate();
    	if (patient != null) {
    		isPatientAuthenticated = delegate.isPatientAuthenticated(patient.getId()).getBoolean();
    	}
    	
    	if(patient != null) {
    		if(patient.getMatchedDateTime() != null){
	    		if(isPatientAuthenticated != null) {
	    			if(isPatientAuthenticated == true && patient.getCorrelationStatus().equals(PatientCorrelationStatusUtils.CORRELATED))
	        			return false;
	    			else if(isPatientAuthenticated == true && !patient.getCorrelationStatus().equals(PatientCorrelationStatusUtils.CORRELATED)) {
	    	            SessionManagement.getInstance().setPatient(request, patient);
        				return true;
	    			}
	        		else if(isPatientAuthenticated == false) {
	    	            SessionManagement.getInstance().setPatient(request, patient);
        				return true;
	        		}
	    		}
	    		else {
    				return true;
	    		}
    		}else{
    			return false;
    		}
    	}
		return false;
    }
}
